import PyPDF2  
import pdfrw  
import tkinter as tk  
from tkinter import filedialog

def flatten_outlines(outlines):  
    flattened = []  
    for outline in outlines:  
        if isinstance(outline, list):  
            flattened.extend(outline)  
        else:  
            flattened.append(outline)  
    return flattened  
  
def copy_annotations(src_pdf, dest_pdf, output_pdf):  
    src_reader = PyPDF2.PdfFileReader(src_pdf)  
    dest_reader = PyPDF2.PdfFileReader(dest_pdf)  
    src_writer = pdfrw.PdfReader(src_pdf)  
    dest_writer = pdfrw.PdfReader(dest_pdf)  
  
    src_outlines = flatten_outlines(src_reader.getOutlines())  
    dest_outlines = flatten_outlines(dest_reader.getOutlines())  
  
    src_outline_page_nums = {outitem.title: src_reader.getDestinationPageNumber(outitem) for outitem in src_outlines}  
    dest_outline_page_nums = {outitem.title: dest_reader.getDestinationPageNumber(outitem) for outitem in dest_outlines}  
  
    for title, src_page_num in src_outline_page_nums.items():  
        if title in dest_outline_page_nums:  
            dest_page_num = dest_outline_page_nums[title]  
            src_page = src_writer.pages[src_page_num]
            dest_page = dest_writer.pages[dest_page_num]  
  
            if pdfrw.PdfName.Annots not in dest_page:  
                dest_page[pdfrw.PdfName.Annots] = []  
  
            if pdfrw.PdfName.Annots in src_page:  
                dest_page[pdfrw.PdfName.Annots].extend(src_page[pdfrw.PdfName.Annots])  
  
    pdfrw.PdfWriter().write(output_pdf, dest_writer)  

# 実行
def main():  
    root = tk.Tk()  
    root.withdraw()  
  
    # コピー元PDFファイルを選択  
    src_pdf = filedialog.askopenfilename(title="Select source PDF file")  
    if not src_pdf:  
        print("No source PDF file selected. Exiting.")  
        return  
  
    # コピー先PDFファイルを選択  
    dest_pdf = filedialog.askopenfilename(title="Select destination PDF file")  
    if not dest_pdf:  
        print("No destination PDF file selected. Exiting.")  
        return  
  
    # 出力PDFファイルを選択  
    output_pdf = filedialog.asksaveasfilename(title="Select output PDF file", defaultextension=".pdf")  
    if not output_pdf:  
        print("No output PDF file selected. Exiting.")  
        return  
  
    # 注釈をコピーする関数を呼び出し
    copy_annotations(src_pdf, dest_pdf, output_pdf)  
    print("Annotations copied successfully.")  
    
if __name__ == "__main__":  
    main()  
